clear all
clc

% Nonlinear map: max/(1 + [(x-centx) (y-centy)]P[(x-centx) (y-centy)]')^root

% Simulation parameters
    tmax   = 80;        % max simulation time
    deltaT = .01;       % simulation time step
    ICx = 1;            % initial x-coordinate in x-y plane
    ICy = 1;            % initial y-coordinate in x-y plane
    
% Nonlinear map parameters
    max = 1;            % max value of nonlinear map
    centx = -1;          % x-coordinate of center of nonlinear map
    centy = -1;          % y-coordinate of center of nonlinear map    
    qx = 1;             % values in Hessian (P)
    qy = 0.5;        
    root = 1;           % can be used to spread map
    
    omega=0.1;          % target moving frequency

% Extremum Seeking parameters
    wx = 30;            % x-loop perturbation frequency
    ax = .05;           % x-loop perturbation amplitude
    cx = 15;            % x-loop gain

    wy = 30;            % y-loop perturbation frequency
    ay = .05;           % y-loop perturbation amplitude
    cy = 15;            % y-loop gain
    
% % Nonlinear Map
% N=100;
% x=linspace(-3,3,N);
% y=linspace(-3,3,N);
% [X,Y]=meshgrid(x,y);
% Z1=max./(1+qx.*(X-centx).^2+qy.*(Y-centy).^2).^(root);
% Z2=max-(qx.*(X-centx).^2+qy.*(Y-centy).^2).^(root);
% figure
% mesh(X,Y,Z1);
% figure
% mesh(X,Y,Z2);
% xlabel('x','FontSize',18,'FontWeight','bold');
% ylabel('y','FontSize',18,'FontWeight','bold');
% zlabel('J','FontSize',18,'FontWeight','bold');
% title('Unknown Function','FontSize',18,'FontWeight','bold');
% grid on;  
% set(gca,'FontSize',12,'FontWeight','bold'); 
% saveas(gcf,'quadraticmap.eps','psc2');